document.addEventListener("DOMContentLoaded", async () => {
    const tableBody = document.getElementById("work-hours-table");
    const clockInBtn = document.getElementById("clock-in-btn");
    const clockOutBtn = document.getElementById("clock-out-btn");

    // Funkcija, lai iegūtu un attēlotu darba stundas
    const fetchWorkHours = async () => {
        try {
            const response = await fetch("../php/work-hours.php?action=fetch-work-hours");
            const result = await response.json();
            renderTable(result.data || []);
        } catch (error) {
            console.error("Kļūda, iegūstot darba stundas:", error);
        }
    };

    // Funkcija, lai attēlotu darba stundas tabulā
    const renderTable = (data) => {
        tableBody.innerHTML = "";
        if (data.length === 0) {
            tableBody.innerHTML = "<tr><td colspan='4'>Darba stundas nav reģistrētas.</td></tr>";
            return;
        }
        data.forEach(row => {
            const tr = document.createElement("tr");
            tr.innerHTML = `
                <td>${row.date || "Nav pieejams"}</td>
                <td>${row.clock_in_time || "Nav pieejams"}</td>
                <td>${row.clock_out_time || "Nav pieejams"}</td>
                <td>${row.total_work_hours || "Nav pieejams"}</td>`;
            tableBody.appendChild(tr);
        });
    };

    // Funkcija, lai apstrādātu ieslēgšanās/izslēgšanās darbības darbiniekiem
    const handleClockAction = async (action) => {
        try {
            const response = await fetch("../php/work-hours.php", {
                method: "POST",
                body: new URLSearchParams({ action }),
            });
            const result = await response.json();
            if (result.success) {
                alert(result.success);
                fetchWorkHours();
            } else if (result.error) {
                alert(result.error);
            }
        } catch (error) {
            console.error(`Kļūda, izpildot ${action}:`, error);
        }
    };

    // Inicializācija
    fetchWorkHours();

    clockInBtn.addEventListener("click", () => handleClockAction("clock-in"));
    clockOutBtn.addEventListener("click", () => handleClockAction("clock-out"));
});
